<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ns1="http://www.mf.gov.pl/SENT/2017/12/08/SENT_187.xsd"
                xmlns:tp="http://www.mf.gov.pl/SENT/2017/12/08/STypes.xsd">
  <xsl:template match="ns1:SENT_187">
    <html>
      <head>
        <style>
          * {
          -webkit-print-color-adjust: exact !important;
          color-adjust: exact !important;
          }

          @media print {
          body {-webkit-print-color-adjust: exact;}
          }

          body {
          font-family: "Helvetica Neue",Helvetica,Arial,sans-serif;
          margin: 0 auto;
          padding: 0 auto;
          }

          .sent-xslt {
          border-collapse: initial;
          }

          .sent-xslt .s1 {
          max-width: 1220px;
          border: 1px solid #c8c9ca;
          }

          .sent-xslt .t1 {
          position: relative;
          display: table;
          width: 100%;
          }

          .sent-xslt .grupName {
          font-size: 12px;
          margin: 0 !important;
          font-weight: bold;
          display:block;
          color: #000000;
          background-color:#dbddde;
          padding:5px 5px 5px 10px;
          border-top: 1px solid #dbddde;
          }

          .sent-xslt .element-1 {
          font-size: 12px;
          font-weight: normal;
          }

          .sent-xslt .grupInfo p {
          margin: 1px 0 1px 10px;
          font-weight: bold;
          font-size: 12px;
          }

          .sent-xslt .grupInfo {
          border-top: 1px solid #dbddde;
          }

          .sent-xslt .table {
          display: table;
          width: 99%;
          margin: 4px 0 15px 7px;
          border-spacing: 0 0;
          border-top: 1px solid #999999;
          border-left: 1px solid #999999;
          }

          .sent-xslt .table-header {
          font-size: 10px;
          font-weight: bold;
          padding: 5px;
          background-color: #ececec;
          border-bottom: 1px solid #999999;
          border-right: 1px solid #999999;
          }

          .sent-xslt .table-element {
          font-size: 12px;
          font-weight: normal;
          padding: 2px 5px;
          border-bottom: 1px solid #999999;
          border-right: 1px solid #999999;
          }

          .sent-xslt .table-element p {
          margin-left: 0;
          }
        </style>
      </head>
      <body>
        <div class="sent-xslt">
          <section class="sent-xslt s1">
            <div class="sent-xslt t1">
              <p class="sent-xslt grupName">INFORMACJA O SPRZEDAŻY</p>
              <div class="sent-xslt grupInfo">
                <table class="sent-xslt table">
                  <tr>
                    <td class="sent-xslt table-header" style="width: 12%">Informacja za rok</td>
                    <td class="sent-xslt table-header" style="width: 12%">Informacja za miesiąc</td>
                    <td class="sent-xslt table-header" style='width: 16%'>Ilość oleju opałowego</td>
                    <td class="sent-xslt table-header" style='width: 10%'>Status</td>
                    <td class="sent-xslt table-header" style='width: 17%'>Data utworzenia</td>
                    <td class="sent-xslt table-header" style='width: 17%'>Wysyłający</td>
                  </tr>
                  <xsl:for-each select="ns1:AgreementBalanceInfo">
                    <tr>
                      <td class="sent-xslt table-element">
                        <xsl:value-of select="tp:BalanceYear"/>
                      </td>
                      <td class="sent-xslt table-element">
                        <xsl:value-of select="tp:BalanceMonth"/>
                      </td>
                      <td class="sent-xslt table-element">
                        <xsl:value-of select="tp:BalanceAmountOfGoods"/>
                      </td>
                      <td class="sent-xslt table-element">
                        <xsl:choose>
                          <xsl:when test="tp:BalanceStatus = '0'">
                            <span>Zarejestrowany</span>
                          </xsl:when>
                          <xsl:when test="tp:BalanceStatus = '2'">
                            <span>Aktywny</span>
                          </xsl:when>
                          <xsl:when test="tp:BalanceStatus = '3'">
                            <span>Zakończony</span>
                          </xsl:when>
                          <xsl:when test="tp:BalanceStatus = '4'">
                            <span>Anulowany</span>
                          </xsl:when>
                        </xsl:choose>
                      </td>
                      <td class="sent-xslt table-element">
                        <xsl:variable name="creBalDate" select="substring-before(tp:BalanceCreationDate, 'T')"/>
                        <xsl:variable name="creBalTime" select="substring(tp:BalanceCreationDate, 12,8)"/>
                        <xsl:value-of select="$creBalDate"/>; <xsl:value-of select="$creBalTime"/>
                      </td>
                      <td class="sent-xslt table-element">
                        <xsl:value-of select="tp:BalanceCreator"/>
                      </td>
                    </tr>
                  </xsl:for-each>
                </table>
              </div>
            </div>
          </section>
        </div>
      </body>
    </html>
  </xsl:template>
</xsl:stylesheet>
